/*
 * Decompiled with CFR 0.152.
 */
package com.github.arnoldbeiland.swingminesweeper.view;

import com.github.arnoldbeiland.swingminesweeper.model.Cell;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;

public class ImageRepository {
    private static final Color BORDER_COLOR = Color.BLACK;
    private static final Color BACKGROUND_COLOR = new Color(180, 180, 180);
    private static final Color COVER_COLOR = new Color(100, 100, 100);
    private static final Color FONT_COLOR = Color.BLUE;
    private static final Color MINE_COLOR = Color.BLACK;
    private static final Color MINE_COLOR_INT = new Color(150, 0, 0);
    private static final Color MARK_COLOR = Color.RED;
    private int size;
    private int globalOffset;
    private int activeSize;
    private Font font;
    private FontMetrics fontMetrics;
    private BufferedImage[] numberContentImages = new BufferedImage[9];
    private BufferedImage[] wrongMarkImages = new BufferedImage[9];
    private BufferedImage mineImage;
    private BufferedImage coveredCellImage;
    private BufferedImage markedCellImage;
    private BufferedImage wellMarkedCellImage;

    public ImageRepository(int size) {
        Graphics2D g2d;
        this.size = size;
        this.activeSize = (int)((double)size * 0.98);
        this.globalOffset = (int)((double)size * 0.01);
        this.setCurrentFont();
        for (int i = 0; i <= 8; ++i) {
            this.numberContentImages[i] = new BufferedImage(size, size, 1);
            g2d = this.numberContentImages[i].createGraphics();
            this.paintBackground(g2d);
            if (i != 0) {
                this.paintCharacter((char)(48 + i), g2d);
            }
            g2d.dispose();
            this.wrongMarkImages[i] = new BufferedImage(size, size, 1);
            g2d = this.wrongMarkImages[i].createGraphics();
            this.paintWrongMark(g2d);
            if (i != 0) {
                this.paintCharacter((char)(48 + i), g2d);
            }
            g2d.dispose();
        }
        this.mineImage = new BufferedImage(size, size, 1);
        g2d = this.mineImage.createGraphics();
        this.paintBackground(g2d);
        this.paintMine(g2d);
        g2d.dispose();
        this.coveredCellImage = new BufferedImage(size, size, 1);
        g2d = this.coveredCellImage.createGraphics();
        this.paintCover(g2d);
        g2d.dispose();
        this.markedCellImage = new BufferedImage(size, size, 1);
        g2d = this.markedCellImage.createGraphics();
        this.paintMark(g2d);
        g2d.dispose();
        this.wellMarkedCellImage = new BufferedImage(size, size, 1);
        g2d = this.wellMarkedCellImage.createGraphics();
        this.paintMark(g2d);
        this.paintMine(g2d);
        g2d.dispose();
    }

    public BufferedImage getImageForCell(Cell cell) {
        if (cell.isCovered()) {
            return cell.isMarked() ? this.markedCellImage : this.coveredCellImage;
        }
        if (cell.isMarked()) {
            return cell.isMine() ? this.wellMarkedCellImage : this.wrongMarkImages[cell.getContent()];
        }
        return cell.isMine() ? this.mineImage : this.numberContentImages[cell.getContent()];
    }

    private void setCurrentFont() {
        FontMetrics fm;
        int targetHeight = this.activeSize;
        int candidateFontSize = 1;
        Font nextFont = new Font("Arial", 0, candidateFontSize);
        FontMetrics nextFontMetrics = new Canvas().getFontMetrics(nextFont);
        int nextHeight = 0;
        do {
            this.font = nextFont;
            this.fontMetrics = nextFontMetrics;
        } while ((nextHeight = (fm = new Canvas().getFontMetrics(nextFont = new Font("Arial", 0, ++candidateFontSize))).getAscent()) <= targetHeight);
    }

    private void paintBackground(Graphics2D g2d) {
        g2d.setColor(BORDER_COLOR);
        g2d.fillRect(0, 0, this.size, this.size);
        g2d.setColor(BACKGROUND_COLOR);
        g2d.fillRect(this.globalOffset, this.globalOffset, this.activeSize, this.activeSize);
    }

    private void paintCharacter(char c, Graphics2D g2d) {
        g2d.setFont(this.font);
        g2d.setColor(FONT_COLOR);
        char[] c_arr = new char[]{c};
        String text = new String(c_arr);
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        int textwidth = (int)this.font.getStringBounds(text, frc).getWidth();
        int woffs = (this.size - textwidth) / 2;
        int hoffs = (int)((double)this.activeSize * 0.92);
        g2d.drawChars(c_arr, 0, 1, woffs, hoffs);
    }

    private void paintCover(Graphics2D g2d) {
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, 0, this.size, this.size);
        g2d.setColor(COVER_COLOR);
        g2d.fillRect(this.globalOffset, this.globalOffset, this.activeSize, this.activeSize);
    }

    private void paintMine(Graphics2D g2d) {
        int ovalSize = (int)((double)this.activeSize * 0.5);
        int ovalOffset = this.globalOffset + (this.activeSize - ovalSize) / 2;
        g2d.setColor(MINE_COLOR);
        g2d.fillOval(ovalOffset, ovalOffset, ovalSize, ovalSize);
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke((float)ovalOffset / 2.6f));
        float strokeStart = (float)this.globalOffset + (float)this.activeSize * 0.2f;
        float strokeEnd = strokeStart + (float)this.activeSize * 0.6f;
        g2d.draw(new Line2D.Float(strokeStart, strokeStart, strokeEnd, strokeEnd));
        g2d.draw(new Line2D.Float(strokeEnd, strokeStart, strokeStart, strokeEnd));
        g2d.setStroke(oldStroke);
        int oval2Size = (int)((double)this.activeSize * 0.09);
        int oval2Offset = this.globalOffset + (int)((double)(this.activeSize - oval2Size) / 2.3);
        g2d.setColor(MINE_COLOR_INT);
        g2d.fillOval(oval2Offset, oval2Offset, oval2Size, oval2Size);
    }

    private void paintMark(Graphics2D g2d) {
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, 0, this.size, this.size);
        g2d.setColor(Color.RED);
        g2d.fillRect(this.globalOffset, this.globalOffset, this.activeSize, this.activeSize);
    }

    private void paintWrongMark(Graphics2D g2d) {
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, 0, this.size, this.size);
        g2d.setColor(MARK_COLOR);
        g2d.fillRect(this.globalOffset, this.globalOffset, this.activeSize, this.activeSize);
        g2d.setColor(BACKGROUND_COLOR);
        int increment = (int)((double)this.activeSize * 0.08);
        g2d.fillRect(this.globalOffset + increment, this.globalOffset + increment, this.activeSize - 2 * increment, this.activeSize - 2 * increment);
    }
}

