/*
 * Decompiled with CFR 0.152.
 */
package com.github.arnoldbeiland.swingminesweeper.view;

import com.github.arnoldbeiland.swingminesweeper.controller.GameController;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ControlBar
extends JPanel {
    private GameController controller;
    private final int[][] boardConfigs = new int[][]{{8, 8}, {15, 25}, {20, 50}};
    private int[] selectedBoardConfig = this.boardConfigs[0];
    private JPanel leftPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private JPanel rightPanel = new JPanel();
    private JButton newGameButton = new JButton("New Game");
    private ButtonGroup myButtonGroup = new ButtonGroup();
    private int timeValue = 0;
    private int stepsValue = 0;
    private JLabel counterLabel = new JLabel();

    public ControlBar() {
        this.newGameButton.addActionListener(e -> this.controller.newGame());
        this.leftPanel.add(this.newGameButton);
        for (int[] bc : this.boardConfigs) {
            JRadioButton currRadio = new JRadioButton(bc[0] + "x" + bc[0], bc == this.selectedBoardConfig);
            currRadio.addActionListener(e -> {
                this.selectedBoardConfig = bc;
            });
            this.centerPanel.add(currRadio);
            this.myButtonGroup.add(currRadio);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.leftPanel, "West");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.counterLabel, "East");
    }

    public void setController(GameController controller) {
        this.controller = controller;
    }

    public int[] getSelectedBoardConfig() {
        return this.selectedBoardConfig;
    }

    public void setTimeValue(int value) {
        this.timeValue = value;
        this.counterLabel.setText(this.stepsValue + " steps / " + this.timeValue + "s");
    }

    public void setStepsValue(int value) {
        this.stepsValue = value;
        this.counterLabel.setText(this.stepsValue + " steps / " + this.timeValue + "s");
    }
}

