/*
 * Decompiled with CFR 0.152.
 */
package com.github.arnoldbeiland.swingminesweeper.view;

import com.github.arnoldbeiland.swingminesweeper.controller.GameController;
import com.github.arnoldbeiland.swingminesweeper.model.Board;
import com.github.arnoldbeiland.swingminesweeper.view.ImageRepository;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class BoardView
extends JPanel {
    private Board board;
    private GameController controller;
    private ImageRepository myImgRepo = null;
    private int boardSize;
    private int cellSize;
    private int panelWidth;
    private int panelHeight;
    private int widthOffset;
    private int heightOffset;

    public BoardView(Board board) {
        this.board = board;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = Math.round((e.getY() - BoardView.this.heightOffset) / BoardView.this.cellSize);
                int col = Math.round((e.getX() - BoardView.this.widthOffset) / BoardView.this.cellSize);
                if (e.getButton() == 1) {
                    BoardView.this.controller.reveal(row, col);
                } else if (e.getButton() == 3) {
                    BoardView.this.controller.toggleMark(row, col);
                }
            }
        });
    }

    public void setController(GameController controller) {
        this.controller = controller;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.panelWidth = this.getWidth();
        this.panelHeight = this.getHeight();
        this.boardSize = Math.min(this.panelWidth - 5, this.panelHeight - 5);
        int newCellSize = this.boardSize / this.board.getSize();
        if (this.myImgRepo == null || this.cellSize != newCellSize) {
            this.cellSize = newCellSize;
            this.myImgRepo = new ImageRepository(this.cellSize);
        }
        this.boardSize = this.cellSize * this.board.getSize();
        this.widthOffset = (this.panelWidth - this.boardSize) / 2;
        this.heightOffset = (this.panelHeight - this.boardSize) / 2;
        for (int i = 0; i < this.board.getSize(); ++i) {
            for (int j = 0; j < this.board.getSize(); ++j) {
                g.drawImage(this.myImgRepo.getImageForCell(this.board.getCell(i, j)), this.widthOffset + j * this.cellSize, this.heightOffset + i * this.cellSize, null);
            }
        }
    }
}

