/*
 * Decompiled with CFR 0.152.
 */
package com.github.arnoldbeiland.swingminesweeper.model;

import com.github.arnoldbeiland.swingminesweeper.model.Cell;
import java.util.Random;

public class Board {
    private Random random = new Random();
    private int size;
    private Cell[][] cells;

    public Board() {
        this(0, null);
    }

    public Board(int size, Cell[][] cells) {
        this.size = size;
        this.cells = cells;
    }

    public int getSize() {
        return this.size;
    }

    public void setSizeReinitCells(int size) {
        this.size = size;
        this.cells = new Cell[size][];
        for (int i = 0; i < size; ++i) {
            this.cells[i] = new Cell[size];
        }
    }

    public Cell getCell(int row, int col) {
        try {
            return this.cells[row][col];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchCellException();
        }
    }

    public void setCell(int row, int col, Cell value) {
        try {
            this.cells[row][col] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchCellException();
        }
    }

    public class NoSuchCellException
    extends RuntimeException {
    }
}

