/*
 * Decompiled with CFR 0.152.
 */
package com.github.arnoldbeiland.swingminesweeper.controller;

import com.github.arnoldbeiland.swingminesweeper.model.Board;
import com.github.arnoldbeiland.swingminesweeper.model.Cell;
import com.github.arnoldbeiland.swingminesweeper.view.BoardView;
import com.github.arnoldbeiland.swingminesweeper.view.ControlBar;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;

public class GameController {
    private Board board;
    private BoardView boardView;
    private ControlBar controlBar;
    private Random random = new Random();
    private Timer timer;
    private int counterValue = 0;
    private int stepsValue = 0;
    private int mineCount;
    private int still_covered;
    private boolean inGame;

    public GameController(Board board, BoardView boardView, ControlBar controlBar) {
        this.board = board;
        this.boardView = boardView;
        this.controlBar = controlBar;
        this.inGame = false;
    }

    public void newGame() {
        this.inGame = true;
        this.board.setSizeReinitCells(this.controlBar.getSelectedBoardConfig()[0]);
        this.mineCount = this.controlBar.getSelectedBoardConfig()[1];
        this.still_covered = this.board.getSize() * this.board.getSize() - this.mineCount;
        this.restart_timer();
        this.fillRandom();
        this.stepsValue = 0;
        this.controlBar.setStepsValue(this.stepsValue);
        this.boardView.repaint();
    }

    public void endGame(boolean won) {
        this.inGame = false;
        this.timer.cancel();
        this.uncoverAll();
        this.boardView.repaint();
        JOptionPane.showMessageDialog(this.boardView, "You " + (won ? "won" : "lost") + "!");
    }

    public void reveal(int row, int col) {
        if (!this.inGame || row < 0 || row >= this.board.getSize() || col < 0 || col >= this.board.getSize()) {
            return;
        }
        if (!this.board.getCell(row, col).isMarked()) {
            this.controlBar.setStepsValue(++this.stepsValue);
            if (this.board.getCell(row, col).isMine()) {
                this.endGame(false);
            } else {
                this.dfs_check_uncover(row, col);
                this.boardView.repaint();
                if (this.still_covered == 0) {
                    this.endGame(true);
                }
            }
        }
    }

    private void dfs_check_uncover(int row, int col) {
        Cell c;
        if (row >= 0 && row < this.board.getSize() && col >= 0 && col < this.board.getSize() && (c = this.board.getCell(row, col)).isCovered() && !c.isMine()) {
            --this.still_covered;
            c.setMarked(false);
            c.setCovered(false);
            if (c.getContent() == 0) {
                this.dfs_check_uncover(row - 1, col - 1);
                this.dfs_check_uncover(row - 1, col);
                this.dfs_check_uncover(row - 1, col + 1);
                this.dfs_check_uncover(row, col - 1);
                this.dfs_check_uncover(row, col + 1);
                this.dfs_check_uncover(row + 1, col - 1);
                this.dfs_check_uncover(row + 1, col);
                this.dfs_check_uncover(row + 1, col + 1);
            }
        }
    }

    public void toggleMark(int row, int col) {
        if (!this.inGame || row < 0 || row >= this.board.getSize() || col < 0 || col >= this.board.getSize()) {
            return;
        }
        Cell c = this.board.getCell(row, col);
        if (c.isCovered()) {
            this.controlBar.setStepsValue(++this.stepsValue);
            c.setMarked(!c.isMarked());
        }
        this.boardView.repaint();
    }

    private void restart_timer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.counterValue = 0;
        this.controlBar.setTimeValue(this.counterValue);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                GameController.this.counterValue++;
                GameController.this.controlBar.setTimeValue(GameController.this.counterValue);
            }
        }, 1000L, 1000L);
    }

    public void fillRandom() {
        int i;
        int size = this.board.getSize();
        for (i = 0; i < this.mineCount; ++i) {
            int cj;
            int ci;
            while (this.board.getCell(ci = this.random.nextInt(size), cj = this.random.nextInt(size)) != null) {
            }
            this.board.setCell(ci, cj, new Cell(-1));
        }
        for (i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (this.board.getCell(i, j) != null) continue;
                int nrmines = (this.isCorrectAndMine(i - 1, j - 1) ? 1 : 0) + (this.isCorrectAndMine(i - 1, j) ? 1 : 0) + (this.isCorrectAndMine(i - 1, j + 1) ? 1 : 0) + (this.isCorrectAndMine(i, j - 1) ? 1 : 0) + (this.isCorrectAndMine(i, j + 1) ? 1 : 0) + (this.isCorrectAndMine(i + 1, j - 1) ? 1 : 0) + (this.isCorrectAndMine(i + 1, j) ? 1 : 0) + (this.isCorrectAndMine(i + 1, j + 1) ? 1 : 0);
                this.board.setCell(i, j, new Cell(nrmines));
            }
        }
    }

    boolean isCorrectAndMine(int i, int j) {
        return i >= 0 && i < this.board.getSize() && j >= 0 && j < this.board.getSize() && this.board.getCell(i, j) != null && this.board.getCell(i, j).isMine();
    }

    public void uncoverAll() {
        for (int i = 0; i < this.board.getSize(); ++i) {
            for (int j = 0; j < this.board.getSize(); ++j) {
                this.board.getCell(i, j).setCovered(false);
            }
        }
    }
}

