/*
    Rendering a square with the biggest possible size and different colors
    based on the zone in which we are relative to the diagonals.

    This file is part of Simple Graphics Framework (SGF).

    Copyright 2023 Arnold Beiland

    Simple Graphics Framework is free software: you can redistribute it and/or
    modify it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along with
    this program (look for a file named COPYING in the top directory). If not, see
    <https://www.gnu.org/licenses/>.
*/

#include "../sgf.h"
#include <iostream>
#include <algorithm>
using namespace std;

void initialize() {}

void render(int width, int height)
{
    int side = min(width, height);
    int margin_cols = (width - side)/2;
    int margin_rows = (height - side)/2;

    Color left { 0, 0, 255 };
    Color right { 0, 255, 0 };
    Color top { 255, 0, 0 };
    Color bottom { 255, 255, 0 };

    for (int i = 0; i < side; ++i)
        for (int j = 0; j < side; ++j)
            if (i > j) {
                if (i + j > side-1)
                    draw_pixel(margin_rows + i, margin_cols + j, bottom);
                else
                    draw_pixel(margin_rows + i, margin_cols + j, left);
            }
            else {
                if (i + j > side-1)
                    draw_pixel(margin_rows + i, margin_cols + j, right);
                else
                    draw_pixel(margin_rows + i, margin_cols + j, top);
            }
}

bool on_scroll(int) { return false; }
bool on_move(int, int) { return false; }
bool on_mouse_down() { return false; }
bool on_mouse_up() { return false; }
bool on_key_down(int) { return false; }
bool on_key_up(int) { return false; }
