/*
    This program will let the user draw on a screen (like a pencil in a paining
    program). First version - putting one pixel on every mouse position.

    This file is part of Simple Graphics Framework (SGF).

    Copyright 2023 Arnold Beiland

    Simple Graphics Framework is free software: you can redistribute it and/or
    modify it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along with
    this program (look for a file named COPYING in the top directory). If not, see
    <https://www.gnu.org/licenses/>.
*/

#include "../sgf.h"
#include <iostream>
#include <algorithm>
#include <cmath>
using namespace std;

const int MAX_ROW = 1080;
const int MAX_COL = 1920;

Color pixels[MAX_ROW][MAX_COL];
int last_mouse_row = 0, last_mouse_col = 0;
bool mouse_down = false;

Color drawing_color = {0,0,0};

void draw_point(int row, int col);

void initialize()
{
    for (int i = 0; i < MAX_ROW; ++i)
        for (int j = 0; j < MAX_COL; ++j)
            pixels[i][j] = {255,255,255};
}

void render(int width, int height)
{
    for (int i = 0; i < min(height, MAX_ROW); i++)
        for (int j = 0; j < min(width, MAX_COL); j++)
            draw_pixel(i, j, pixels[i][j]);
}

bool on_move(int row, int col)
{
    last_mouse_row = row;
    last_mouse_col = col;

    if (mouse_down) {
        draw_point(row, col);
        return true;
    }

    return false;
}

bool on_mouse_down()
{
    mouse_down = true;
    draw_point(last_mouse_row, last_mouse_col);
    return true;
}

bool on_mouse_up()
{
    mouse_down = false;
    return false;
}

void draw_point(int row, int col)
{
    if (row >= 0 && row < MAX_ROW && col >= 0 && col < MAX_COL)
        pixels[row][col] = drawing_color;
}

bool on_scroll(int) { return false; }
bool on_key_down(int) { return false; }
bool on_key_up(int) { return false; }
