/*
    Renders a color gradient from yellow to orange based on the distance
    from the top left corner.

    This file is part of Simple Graphics Framework (SGF).

    Copyright 2023 Arnold Beiland

    Simple Graphics Framework is free software: you can redistribute it and/or
    modify it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along with
    this program (look for a file named COPYING in the top directory). If not, see
    <https://www.gnu.org/licenses/>.
*/

#include "../sgf.h"
#include <iostream>
#include <algorithm>
#include <cmath>
using namespace std;

Color combine(Color c1, Color c2, double ratio);

void initialize() {}

void render(int width, int height)
{
    Color c1 {255,255,50};
    Color c2 {230,30,30};

    for (int i = 0; i < height; ++i)
        for (int j = 0; j < width; ++j) {
            double ratio = sqrt(1.0 * (i*i + j*j) / (height*height + width*width));
            Color c = combine(c1, c2, ratio);
            draw_pixel(i, j, c);
        }
}

Color combine(Color c1, Color c2, double ratio)
{
    Color c;
    c.r = c1.r * (1-ratio) + c2.r * ratio;
    c.g = c1.g * (1-ratio) + c2.g * ratio;
    c.b = c1.b * (1-ratio) + c2.b * ratio;
    return c;
}

bool on_scroll(int) { return false; }
bool on_move(int, int) { return false; }
bool on_mouse_down() { return false; }
bool on_mouse_up() { return false; }
bool on_key_down(int) { return false; }
bool on_key_up(int) { return false; }
