/*
    Rendering a chessboard

    This file is part of Simple Graphics Framework (SGF).

    Copyright 2023 Arnold Beiland

    Simple Graphics Framework is free software: you can redistribute it and/or
    modify it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along with
    this program (look for a file named COPYING in the top directory). If not, see
    <https://www.gnu.org/licenses/>.
*/

#include "../sgf.h"
#include <iostream>
#include <algorithm>
using namespace std;

void initialize()
{
}

void render(int width, int height)
{
    int side = min(width, height)/8;
    int margin_cols = (width - 8*side)/2;
    int margin_rows = (height - 8*side)/2;

    Color light { 220, 180, 130 };
    Color dark { 90, 40, 0 };

    for (int i = 0; i < 8; ++i)
        for (int j = 0; j < 8; ++j) {
            Color color = (i+j)%2 == 0 ? light : dark;
            for (int row = 0; row < side; ++row)
                for (int col = 0; col < side; ++col)
                    draw_pixel(
                        margin_rows + i*side + row,
                        margin_cols + j*side + col,
                        color);
        }
}

bool on_scroll(int) { return false; }
bool on_move(int, int) { return false; }
bool on_mouse_down() { return false; }
bool on_mouse_up() { return false; }
bool on_key_down(int) { return false; }
bool on_key_up(int) { return false; }
