QT += testlib
QT -= gui

CONFIG += qt console warn_on depend_includepath testcase
CONFIG -= app_bundle

win32 {
    message("Windows platform...")

    msvc {
      QMAKE_CXXFLAGS += -openmp -arch:AVX -D "_CRT_SECURE_NO_WARNINGS"
      QMAKE_CXXFLAGS_RELEASE *= -O2
    }
}

unix {
    QMAKE_CXXFLAGS += -fopenmp -W -Wall -Wextra -Wconversion
    QMAKE_CXXFLAGS_WARN_ON += -W -Wall -Wextra -Wconversion
    QMAKE_LFLAGS +=  -fopenmp
    LIBS += -fopenmp
}


TEMPLATE = app

SOURCES +=  \
    main.cpp \
    ../project/EC/CharacteristicPolynomial.cpp \
    ../project/EC/ECSpace.cpp \
    ../project/EC/OrdinaryBasisFunction.cpp \
    ../project/Core/PascalTriangles.cpp \
    ../project/Core/RealMatrices.cpp \
    ../project/Core/RealMatrixDecompositions.cpp \
    BasisTransformation/BasisTransformationTests.cpp \
    ECSpaces/PolynomialECSpaceTests.cpp \
    ECSpaces/T1ECSpaceTests.cpp \
    OrdinaryBasisFunctions/OrdinaryBasisFunctionTests.cpp

HEADERS += \
    ../project/Utils/DoubleEquality.h \
    ../project/Core/Constants.h \
    ../project/EC/CharacteristicPolynomial.h \
    ../project/EC/ECSpace.h \
    ../project/EC/OrdinaryBasisFunction.h \
    ../project/Core/Constants.h \
    ../project/Core/Exceptions.h \
    ../project/Core/Matrices.h \
    ../project/Core/PascalTriangles.h \
    ../project/Core/RealMatrices.h \
    ../project/Core/RealMatrixDecompositions.h \
    BasisTransformation/BasisTransformationTests.h \
    ECSpaces/PolynomialECSpaceTests.h \
    ECSpaces/T1ECSpaceTests.h \
    OrdinaryBasisFunctions/OrdinaryBasisFunctionTests.h
