#include <QTest>
#include <iostream>

#include "OrdinaryBasisFunctions/OrdinaryBasisFunctionTests.h"
#include "ECSpaces/PolynomialECSpaceTests.h"
#include "ECSpaces/T1ECSpaceTests.h"
#include "BasisTransformation/BasisTransformationTests.h"

int main(int argc, char** argv)
{
    int status = 0;

    {
        OrdinaryBasisFunctionTests testCase;
        status |= QTest::qExec(&testCase, argc, argv);
    }

    {
        PolynomialECSpaceTests testCase;
        status |= QTest::qExec(&testCase, argc, argv);
    }

    {
        T1ECSpaceTests testCase;
        status |= QTest::qExec(&testCase, argc, argv);
    }

    {
        BasisTransformationTests testCase;
        status |= QTest::qExec(&testCase, argc, argv);
    }

   if (status != 0)
       std::cerr << "NOT ALL TESTS HAVE PASSED !!!\n";
   else
       std::cerr << "ALL TESTS OK\n";

   return status;
}
