#pragma once

#include <QTest>
#include <cmath>
#include "../project/EC/ECSpace.h"

class T1ECSpaceTests: public QObject
{
    Q_OBJECT

private:
    const double TOLERANCE = 0.0000000001;

    double _beta;
    double _scaleFactor;
    double _midScaleTerm;

    cagd::ECSpace *_ecSpace;

    double explicit0(double u);
    double explicit1(double u);
    double explicit2(double u);

    double explicitDer0(double u);
    double explicitDer1(double u);
    double explicitDer2(double u);

private slots:
    void initTestCase();
    void cleanupTestCase();
    void valuesTest();
    void firstOrderDerivativesTest();
};
