#include "T1ECSpaceTests.h"
#include "../../project/EC/ECSpace.h"
#include <cmath>
using namespace std;
using namespace cagd;

void T1ECSpaceTests::initTestCase()
{
    _beta = 1.4;
    _scaleFactor = 1.0 / std::pow(std::sin(_beta / 2), 2);
    _midScaleTerm = 2.0 * std::cos(_beta / 2);

    _ecSpace = new ECSpace();
    _ecSpace->definitionDomain = std::make_pair(0.0, _beta);
    _ecSpace->characteristicPolynomial.zeros.resize(2);

    _ecSpace->characteristicPolynomial.zeros[0].real = 0;
    _ecSpace->characteristicPolynomial.zeros[0].absImaginary = 0;
    _ecSpace->characteristicPolynomial.zeros[0].multiplicity = 1;

    _ecSpace->characteristicPolynomial.zeros[1].real = 0;
    _ecSpace->characteristicPolynomial.zeros[1].absImaginary = 1;
    _ecSpace->characteristicPolynomial.zeros[1].multiplicity = 1;

    _ecSpace->preprocessing();
}

void T1ECSpaceTests::cleanupTestCase()
{
    delete _ecSpace;
}

void T1ECSpaceTests::valuesTest()
{
    for (double input = 0; input <= 1; input += 0.001) {
        QVERIFY2(
            std::abs(_ecSpace->NNBBaseDerivative(0, 0, input) - explicit0(input)) < TOLERANCE,
            "First basis function wrong");

        QVERIFY2(
            std::abs(_ecSpace->NNBBaseDerivative(1, 0, input) - explicit1(input)) < TOLERANCE,
            "Second basis function wrong");

        QVERIFY2(
            std::abs(_ecSpace->NNBBaseDerivative(2, 0, input) - explicit2(input)) < TOLERANCE,
            "Third basis function wrong");
    }
}

void T1ECSpaceTests::firstOrderDerivativesTest()
{
    for (double input = 0; input <= 1; input += 0.001) {
        QVERIFY2(
            std::abs(_ecSpace->NNBBaseDerivative(0, 1, input) - explicitDer0(input)) < TOLERANCE,
            "First basis function derivative wrong");

        QVERIFY2(
            std::abs(_ecSpace->NNBBaseDerivative(1, 1, input) - explicitDer1(input)) < TOLERANCE,
            "Second basis function derivative wrong");

        QVERIFY2(
            std::abs(_ecSpace->NNBBaseDerivative(2, 1, input) - explicitDer2(input)) < TOLERANCE,
            "Third basis function derivative wrong");
    }
}


double T1ECSpaceTests::explicit0(double u)
{
    return _scaleFactor * pow(sin((_beta - u) / 2), 2);
}

double T1ECSpaceTests::explicit1(double u)
{
    return _midScaleTerm * _scaleFactor * sin((_beta - u) / 2) * sin(u / 2) ;
}

double T1ECSpaceTests::explicit2(double u)
{
    return _scaleFactor * pow(sin(u / 2), 2);
}


double T1ECSpaceTests::explicitDer0(double u)
{
    return _scaleFactor * (-1) * sin((_beta - u) / 2) * cos((_beta - u) / 2);
}

double T1ECSpaceTests::explicitDer1(double u)
{
    return _midScaleTerm * _scaleFactor * (
        (-0.5) * cos((_beta - u) / 2) * sin(u / 2)
        + 0.5 * sin((_beta - u) / 2) * cos(u / 2)
    );
}

double T1ECSpaceTests::explicitDer2(double u)
{
    return _scaleFactor * sin(u / 2) * cos(u / 2);
}


