#include "PolynomialECSpaceTests.h"
#include "../../project/Core/Constants.h"
#include "../../project/EC/ECSpace.h"
#include "../../project/Utils/DoubleEquality.h"
#include <cmath>
using namespace cagd;

void PolynomialECSpaceTests::oneDimensionalNNBTest()
{
    genericTest(1);
}

void PolynomialECSpaceTests::twoDimensionalNNBTest()
{
    genericTest(2);
}

void PolynomialECSpaceTests::threeDimensionalNNBTest()
{
    genericTest(3);
}

void PolynomialECSpaceTests::fourDimensionalNNBTest()
{
    genericTest(4);
}

void PolynomialECSpaceTests::fiveDimensionalNNBTest()
{
    genericTest(5);
}

void PolynomialECSpaceTests::tenDimensionalNNBTest()
{
    genericTest(10);
}



void PolynomialECSpaceTests::genericTest(unsigned dimension)
{
    cagd::ECSpace space;
    space.definitionDomain.first = 0;
    space.definitionDomain.second = 1;

    space.characteristicPolynomial.zeros.resize(1);
    space.characteristicPolynomial.zeros[0].real = 0;
    space.characteristicPolynomial.zeros[0].absImaginary = 0;
    space.characteristicPolynomial.zeros[0].multiplicity = dimension;

    space.preprocessing();

    for (unsigned order = 0; order <= dimension; ++order)
        for (unsigned index = 0; index < dimension; ++index)
            for (double input = 0; input <= 1; input += 0.001)
                QVERIFY2(
                    std::abs(
                        space.NNBBaseDerivative(index, order, input) -
                        bernstein_derivative(dimension - 1, index, order, input)) < TOLERANCE,
                    "NNB and Bernstein values do not match.");
}

double PolynomialECSpaceTests::bernstein_derivative(int n, int k, int deriv_order, double u)
{
    if (k<0 || k>n)
        return 0;

    if (deriv_order > 0)
        return n * (
            bernstein_derivative(n-1, k-1, deriv_order-1, u) -
            bernstein_derivative(n-1, k, deriv_order-1, u)
        );

    return BC(n,k) * std::pow(u,k) * std::pow(1-u, n-k);
}
