#include "BasisTransformationTests.h"
#include "../../project/EC/ECSpace.h"
using namespace cagd;

void BasisTransformationTests::testForBernstein()
{
    ECSpace space;
    space.definitionDomain.first = 0;
    space.definitionDomain.second = 1;

    space.characteristicPolynomial.zeros.resize(1);
    space.characteristicPolynomial.zeros[0].real = 0;
    space.characteristicPolynomial.zeros[0].absImaginary = 0;
    space.characteristicPolynomial.zeros[0].multiplicity = 6;

    space.preprocessing();

    RealMatrix transformation = space.getBasisTransformationMatrix();

    for (unsigned step = 0; step <= 100; ++step) {
        double u = std::min(
            space.definitionDomain.second,
            space.definitionDomain.first +
                (space.definitionDomain.second - space.definitionDomain.first) * step / 100);

        std::vector<double> ordinaryBasisValues(space.getDimension());
        RealMatrix nnbBasisValues(space.getDimension(), 1);
        for (unsigned i = 0; i < space.getDimension(); ++i) {
            ordinaryBasisValues[i] = space.ordBases[i].getDerivative(0, u);
            nnbBasisValues(i, 0) = space.NNBBaseDerivative(i, 0, u);
        }

        RealMatrix product = transformation * nnbBasisValues;

        for (unsigned i = 0; i < space.getDimension(); ++i) {
            QVERIFY2(
                std::abs(product(i,0) - ordinaryBasisValues[i]) < TOLERANCE,
                "Basis transformation error.");
        }
    }
}

void BasisTransformationTests::testForTrigonometric()
{
    ECSpace space;
    space.definitionDomain.first = 0;
    space.definitionDomain.second = 3.1415;

    space.characteristicPolynomial.zeros.resize(1);
    space.characteristicPolynomial.zeros[0].real = 0;
    space.characteristicPolynomial.zeros[0].absImaginary = 1;
    space.characteristicPolynomial.zeros[0].multiplicity = 2;

    space.preprocessing();

    RealMatrix transformation = space.getBasisTransformationMatrix();

    for (unsigned step = 0; step <= 100; ++step) {
        double u = std::min(
            space.definitionDomain.second,
            space.definitionDomain.first +
                (space.definitionDomain.second - space.definitionDomain.first) * step / 100);

        std::vector<double> ordinaryBasisValues(space.getDimension());
        RealMatrix nnbBasisValues(space.getDimension(), 1);
        for (unsigned i = 0; i < space.getDimension(); ++i) {
            ordinaryBasisValues[i] = space.ordBases[i].getDerivative(0, u);
            nnbBasisValues(i, 0) = space.NNBBaseDerivative(i, 0, u);
        }

        RealMatrix product = transformation * nnbBasisValues;

        for (unsigned i = 0; i < space.getDimension(); ++i) {
            QVERIFY2(
                std::abs(product(i,0) - ordinaryBasisValues[i]) < TOLERANCE,
                "Basis transformation error.");
        }
    }
}

void BasisTransformationTests::testForAlgebraicTrigonometric()
{
    ECSpace space;
    space.definitionDomain.first = 0;
    space.definitionDomain.second = 3.1415;

    space.characteristicPolynomial.zeros.resize(2);
    space.characteristicPolynomial.zeros[0].real = 0;
    space.characteristicPolynomial.zeros[0].absImaginary = 0;
    space.characteristicPolynomial.zeros[0].multiplicity = 3;
    space.characteristicPolynomial.zeros[1].real = 0;
    space.characteristicPolynomial.zeros[1].absImaginary = 1;
    space.characteristicPolynomial.zeros[1].multiplicity = 2;

    space.preprocessing();

    RealMatrix transformation = space.getBasisTransformationMatrix();

    for (unsigned step = 0; step <= 100; ++step) {
        double u = std::min(
            space.definitionDomain.second,
            space.definitionDomain.first +
                (space.definitionDomain.second - space.definitionDomain.first) * step / 100);

        std::vector<double> ordinaryBasisValues(space.getDimension());
        RealMatrix nnbBasisValues(space.getDimension(), 1);
        for (unsigned i = 0; i < space.getDimension(); ++i) {
            ordinaryBasisValues[i] = space.ordBases[i].getDerivative(0, u);
            nnbBasisValues(i, 0) = space.NNBBaseDerivative(i, 0, u);
        }

        RealMatrix product = transformation * nnbBasisValues;

        for (unsigned i = 0; i < space.getDimension(); ++i) {
            QVERIFY2(
                std::abs(product(i,0) - ordinaryBasisValues[i]) < TOLERANCE,
                "Basis transformation error.");
        }
    }
}
