QT += core gui widgets opengl

win32 {
    message("Windows platform...")

    INCLUDEPATH += $$PWD/WinDependencies/Include
    DEPENDPATH += $$PWD/WinDependencies/Include

    LIBS += -lopengl32 -lglu32

    CONFIG(release, debug|release): {
        contains(QT_ARCH, i386) {
            message("x86 (i.e., 32-bit) release build")
            LIBS += -L"$$PWD/WinDependencies/Lib/GL/x86/" -lglew32
        } else {
            message("x86_64 (i.e., 64-bit) release build")
            LIBS += -L"$$PWD/WinDependencies/Lib/GL/x86_64/" -lglew32
        }
    } else: CONFIG(debug, debug|release): {
        contains(QT_ARCH, i386) {
            message("x86 (i.e., 32-bit) debug build")
            LIBS += -L"$$PWD/WinDependencies/Lib/GL/x86/" -lglew32
        } else {
            message("x86_64 (i.e., 64-bit) debug build")
            LIBS += -L"$$PWD/WinDependencies/Lib/GL/x86_64" -lglew32
        }
    }

    msvc {
      QMAKE_CXXFLAGS += -openmp -arch:AVX -D "_CRT_SECURE_NO_WARNINGS"
      QMAKE_CXXFLAGS_RELEASE *= -O2
    }
}

unix {
    QMAKE_CXXFLAGS += -fopenmp
    QMAKE_CXXFLAGS_WARN_ON += -W -Wall -Wextra -Wconversion
    QMAKE_LFLAGS +=  -fopenmp
    LIBS += -lGLEW -lGLU -lGL -fopenmp
}

SOURCES += \
    main.cpp \
    Core/Lights.cpp \
    Core/Materials.cpp \
    Core/TriangulatedMeshes3.cpp \
    Core/ShaderPrograms.cpp \
    Core/LinearCombination3.cpp \
    Core/TensorProductSurfaces3.cpp \
    Core/GenericCurves3.cpp \
    EC/BCurve3.cpp \
    EC/ECSpace.cpp \
    EC/BSurface3.cpp \
    GUI/SetupECSpaces/SetupECSpacesDialog.cpp \
    GUI/SetupECSpaces/ZeroItemWidget.cpp \
    EC/CharacteristicPolynomial.cpp \
    GUI/SetupECSpaces/SaveForLaterUseDialog.cpp \
    GUI/SetupECSpaces/ECSpaceDatabase.cpp \
    GUI/SetupECSpaces/LoadExistingSpaceDialog.cpp \
    GUI/SetupECSpaces/PreviewECWidget.cpp \
    GUI/SetupECSpaces/NNBBasesGLWidget.cpp \
    EC/OrdinaryBasisFunction.cpp \
    Core/RealMatrices.cpp \
    Core/RealMatrixDecompositions.cpp \
    Core/PascalTriangles.cpp \
    GUI/CommonUITools.cpp \
    GUI/Model/Scene.cpp \
    GUI/Model/CurveItem.cpp \
    GUI/Model/SurfaceItem.cpp \
    GUI/CurveSetupTab.cpp \
    GUI/GLWidget.cpp \
    GUI/MainWindow.cpp \
    GUI/SideWidget.cpp \
    GUI/ViewTab.cpp \
    GUI/SurfaceSetupTab.cpp \
    Core/GeometryHelper.cpp \
    GUI/PointSetupTab.cpp \
    GUI/SetupExactDescription/SetupExactDescriptionDialog.cpp \
    GUI/SetupExactDescription/BasisColumn.cpp \
    Utils/benchmarking.cpp

FORMS += \
    GUI/SetupECSpaces/SetupECSpacesDialog.ui \
    GUI/SetupECSpaces/ZeroItemWidget.ui \
    GUI/SetupECSpaces/SaveForLaterUseDialog.ui \
    GUI/SetupECSpaces/LoadExistingSpaceDialog.ui \
    GUI/SetupECSpaces/PreviewECWidget.ui \
    GUI/CurveSetupTab.ui \
    GUI/MainWindow.ui \
    GUI/SideWidget.ui \
    GUI/ViewTab.ui \
    GUI/SurfaceSetupTab.ui \
    GUI/PointSetupTab.ui \
    GUI/SetupExactDescription/SetupExactDescriptionDialog.ui \
    GUI/SetupExactDescription/BasisColumn.ui



HEADERS += \
    Core/Exceptions.h \
    Core/DCoordinates3.h \
    Core/Matrices.h \
    Core/GenericCurves3.h \
    Core/Constants.h \
    Core/ShaderPrograms.h \
    Core/Lights.h \
    Core/Materials.h \
    Core/TCoordinates4.h \
    Core/TriangularFaces.h \
    Core/TriangulatedMeshes3.h \
    Core/Colors4.h \
    Core/HCoordinates3.h \
    Core/LinearCombination3.h \
    Core/TensorProductSurfaces3.h \
    EC/ECSpace.h \
    EC/BCurve3.h \
    EC/BSurface3.h \
    GUI/SetupECSpaces/SetupECSpacesDialog.h \
    GUI/SetupECSpaces/ZeroItemWidget.h \
    Utils/DoubleEquality.h \
    GUI/SetupECSpaces/ECSpaceDatabase.h \
    EC/CharacteristicPolynomial.h \
    GUI/SetupECSpaces/SaveForLaterUseDialog.h \
    GUI/SetupECSpaces/LoadExistingSpaceDialog.h \
    GUI/SetupECSpaces/PreviewECWidget.h \
    GUI/SetupECSpaces/NNBBasesGLWidget.h \
    EC/OrdinaryBasisFunction.h \
    Core/RealMatrixDecompositions.h \
    Core/RealMatrices.h \
    Core/PascalTriangles.h \
    GUI/CommonUITools.h \
    GUI/Model/Scene.h \
    GUI/Model/SceneItem.h \
    GUI/Model/CurveItem.h \
    GUI/Model/SurfaceItem.h \
    GUI/CurveSetupTab.h \
    GUI/GLWidget.h \
    GUI/MainWindow.h \
    GUI/SideWidget.h \
    GUI/ViewTab.h \
    GUI/SurfaceSetupTab.h \
    Core/GeometryHelper.h \
    GUI/PointSetupTab.h \
    GUI/SetupExactDescription/SetupExactDescriptionDialog.h \
    GUI/SetupExactDescription/BasisColumn.h \
    Utils/benchmarking.h


RESOURCES += \
    Resources/error.png \
    Resources/plus_25x25.png \
    Resources/save_25x25.png \
    Resources/delete_25x25.png \
    Resources/leftbrace.png \
    Resources/sphere.off \
    Resources/Shaders/two_sided_lighting.vert \
    Resources/Shaders/two_sided_lighting.frag
