#include <QApplication>
#include "GUI/MainWindow.h"
#include "GUI/SetupECSpaces/SetupECSpacesDialog.h"
#include "GUI/SetupECSpaces/ECSpaceDatabase.h"
#include "EC/ECSpace.h"
#include "Utils/DoubleEquality.h"
#include "EC/CharacteristicPolynomial.h"
#include "EC/OrdinaryBasisFunction.h"
#include <iostream>
#include <cmath>
#include <cstdlib>
#include <ctime>
#include <QMessageBox>
#include "Utils/benchmarking.h"
using namespace std;

cagd::ECSpaceDatabase database;

int main(int argc, char **argv)
{
    try
    {
        std::srand((unsigned) std::time(NULL));

        QApplication app(argc, argv);
        app.setAttribute(Qt::AA_UseDesktopOpenGL, true);

        cagd::MainWindow mainWindow;
        mainWindow.showMaximized();

        return app.exec();
     }
     catch(...)
     {
        QMessageBox::critical(nullptr, "Error", "Urecognized error!");
        std::abort();
     }

//      benchmark_curves();
//      benchmark_surfaces();
//      return 0;
}


