#pragma once

#include <QWidget>
#include "CommonUITools.h"
#include "Model/Scene.h"

namespace Ui {
    class ViewTab;
}

namespace cagd
{
    class ViewTab : public QWidget
    {
        Q_OBJECT

    public:
        explicit ViewTab(QWidget *parent, Scene *scene);
        ~ViewTab();

    signals:
        void configChanged();
        void setDefaultView();
        void moveSelectionToCenter();

    public slots:
        void updateFromScene();

    private:
        Ui::ViewTab *ui;
        Scene *_scene;

    private slots:
        void lineWidthChanged(double);
        void selectionLineWidthChanged(double);
        void curveDivPointCountChanged(int);
        void surfaceDivPointCountChanged(int);
        void isoLineCountChanged(int);
        void setControlLinesColor();
        void setBackgroundColor();
        void addDummyCurve();
        void loadCurveFromFile();
        void addDummySurface();
        void loadSurfaceFromFile();
        void loadConfigurationFromFile();
        void saveConfigurationToFile();
    };
}
