#pragma once

#include <string>
#include <QWidget>
#include "Model/Scene.h"

namespace Ui {
    class SurfaceSetupTab;
}

namespace cagd
{
    class SurfaceSetupTab : public QWidget
    {
        Q_OBJECT

    public:
        explicit SurfaceSetupTab(QWidget *parent, Scene *scene);
        ~SurfaceSetupTab();

    signals:
        void configChanged();
        void activateMainGLWidget();

    public slots:
        void updateFromScene();

    private:
        Ui::SurfaceSetupTab *ui;
        Scene *_scene;

        std::string formatDouble(double d) const;

    private slots:
        void alwaysShowControlNetChanged(bool);
        void showNormalsChanged(bool);
        void showIsoLinesChanged(bool);
        void setNormalsColor();
        void setIsoLinesColor();
        void materialChanged(int);
        void deleteSurface();
        void setupECSpaceUClicked();
        void setupECSpaceVClicked();
        void exactDescriptionClicked();
        void performOrderElevationU();
        void performOrderElevationV();
        void performUSubdivision();
        void performVSubdivision();
        void saveSurfaceToFile();
    };
}
