#pragma once

#include <QWidget>
#include "ui_SideWidget.h"
#include "ViewTab.h"
#include "CurveSetupTab.h"
#include "SurfaceSetupTab.h"
#include "PointSetupTab.h"
#include "Model/Scene.h"

namespace cagd
{
    class SideWidget: public QWidget, public Ui::SideWidget
    {
        Q_OBJECT
    public:
        SideWidget(QWidget *parent, Scene *scene);

    public slots:
        void sceneChanged();

    signals:
        void modifiedTheScene();
        void setDefaultView();
        void moveSelectionToCenter();
        void activateMainGLWidget();

    private:
        Scene *_scene;

        ViewTab *_viewTab;
        CurveSetupTab *_curveSetupTab;
        SurfaceSetupTab *_surfaceSetupTab;
        PointSetupTab *_pointSetupTab;

    private slots:
        void childHadModifications();
    };
}
