#include "SideWidget.h"

#include <QTabWidget>
#include <QHBoxLayout>
#include "Model/CurveItem.h"
#include "Model/SurfaceItem.h"

namespace cagd
{
    SideWidget::SideWidget(QWidget *parent, Scene *scene):
        QWidget(parent),
        _scene(scene)
    {
        setupUi(this);

        _viewTab = new ViewTab(this, _scene);
        tabWidgetViewTab->setLayout(new QHBoxLayout());
        tabWidgetViewTab->layout()->setContentsMargins(0, 11, 0, 11);
        tabWidgetViewTab->layout()->addWidget(_viewTab);

        _curveSetupTab = new CurveSetupTab(this, _scene);
        tabWidgetCurveSetupTab->setLayout(new QHBoxLayout());
        tabWidgetCurveSetupTab->layout()->setContentsMargins(0, 0, 0, 11);
        tabWidgetCurveSetupTab->layout()->addWidget(_curveSetupTab);

        _surfaceSetupTab = new SurfaceSetupTab(this, _scene);
        tabWidgetSurfaceSetupTab->setLayout(new QHBoxLayout());
        tabWidgetSurfaceSetupTab->layout()->setContentsMargins(0, 0, 0, 11);
        tabWidgetSurfaceSetupTab->layout()->addWidget(_surfaceSetupTab);

        _pointSetupTab = new PointSetupTab(this, _scene);
        tabWidgetPointSetupTab->setLayout(new QHBoxLayout());
        tabWidgetPointSetupTab->layout()->setContentsMargins(0, 0, 0, 11);
        tabWidgetPointSetupTab->layout()->addWidget(_pointSetupTab);

        connect(_viewTab, SIGNAL(configChanged()), this, SLOT(childHadModifications()));
        connect(_curveSetupTab, SIGNAL(configChanged()), this, SLOT(childHadModifications()));
        connect(_curveSetupTab, SIGNAL(activateMainGLWidget()), this, SIGNAL(activateMainGLWidget()));
        connect(_surfaceSetupTab, SIGNAL(configChanged()), this, SLOT(childHadModifications()));
        connect(_surfaceSetupTab, SIGNAL(activateMainGLWidget()), this, SIGNAL(activateMainGLWidget()));
        connect(_pointSetupTab, SIGNAL(configChanged()), this, SLOT(childHadModifications()));

        connect(_viewTab, SIGNAL(setDefaultView()), this, SIGNAL(setDefaultView()));
        connect(_viewTab, SIGNAL(moveSelectionToCenter()), this, SIGNAL(moveSelectionToCenter()));
    }

    void SideWidget::sceneChanged()
    {
        CurveItem *curve = dynamic_cast<CurveItem *>(_scene->selection.selectedItem);
        SurfaceItem *surface = dynamic_cast<SurfaceItem *>(_scene->selection.selectedItem);

        _viewTab->updateFromScene();

        tabWidget->setTabEnabled(1, curve != nullptr);
        if (curve != nullptr) {
            _curveSetupTab->updateFromScene();
            if (_scene->shouldTriggerTabChange)
                tabWidget->setCurrentIndex(1);
        }

        tabWidget->setTabEnabled(2, surface != nullptr);
        if (surface != nullptr) {
            _surfaceSetupTab->updateFromScene();
            if (_scene->shouldTriggerTabChange)
                tabWidget->setCurrentIndex(2);
        }

        tabWidget->setTabEnabled(3, _scene->selection.isPoint());
        if (_scene->selection.isPoint()) {
            _pointSetupTab->updateFromScene();
            if (_scene->shouldTriggerTabChange)
                tabWidget->setCurrentIndex(3);
        }

        _scene->shouldTriggerTabChange = false;
    }

    void SideWidget::childHadModifications() {
        sceneChanged();
        modifiedTheScene();
    }
}
