#pragma once

#include <QDialog>
#include <QLabel>
#include <vector>
#include <sstream>
#include "../../EC/ECSpace.h"
#include "../../Core/DCoordinates3.h"

namespace Ui
{
    class SetupExactDescriptionDialog;
}

namespace cagd
{
    class SetupExactDescriptionDialog : public QDialog
    {
        Q_OBJECT

    public:
        explicit SetupExactDescriptionDialog(
            QWidget *parent,
            std::vector<DCoordinate3> *resultVec,
            ECSpace *ecSpaceU,
            ECSpace *ecSpaceV = nullptr);
        ~SetupExactDescriptionDialog();

    private:
        Ui::SetupExactDescriptionDialog *ui;
        QLabel *_summaryLabel;
        ECSpace *_ecSpaceU, *_ecSpaceV;
        std::vector<DCoordinate3> &_result;
        unsigned _columnCount;
        void addColumns();
        std::string textForColumn(int index);
        std::string formatTrimmed(double value);
        bool writeSummaryColumn(std::stringstream &ss, int columnIndex, double value, bool wasAnythingWritten);

    signals:
        void updateColumns();

    private slots:
        void generateSummary();
        void saveToFile();
        void loadFromFile();
    };
}

