#pragma once

#include <QWidget>
#include <string>
#include "../../Core/DCoordinates3.h"

namespace Ui {
class BasisColumn;
}

namespace cagd
{
    class BasisColumn : public QWidget
    {
        Q_OBJECT

    public:
        explicit BasisColumn(QWidget *parent, DCoordinate3 *coord, std::string text);
        ~BasisColumn();

    signals:
        void tripletChanged();

    public slots:
        void updateValues();

    private:
        Ui::BasisColumn *ui;
        DCoordinate3 *_coord;

    private slots:
        void xChanged(double);
        void yChanged(double);
        void zChanged(double);
    };
}
