#include "BasisColumn.h"
#include "ui_BasisColumn.h"

#include <QLabel>
#include <QSpinBox>

namespace cagd
{
    BasisColumn::BasisColumn(QWidget *parent, DCoordinate3 *coord, std::string text) :
        QWidget(parent),
        ui(new Ui::BasisColumn),
        _coord(coord)
    {
        ui->setupUi(this);
        ui->xSpinBox->setStyleSheet("background-color: white;");
        ui->ySpinBox->setStyleSheet("background-color: white;");
        ui->zSpinBox->setStyleSheet("background-color: white;");
        ui->label->setText(text.c_str());

        connect(ui->xSpinBox, SIGNAL(valueChanged(double)), this, SLOT(xChanged(double)));
        connect(ui->ySpinBox, SIGNAL(valueChanged(double)), this, SLOT(yChanged(double)));
        connect(ui->zSpinBox, SIGNAL(valueChanged(double)), this, SLOT(zChanged(double)));

        _coord->x() = _coord->y() = _coord->z() = 0;
    }

    BasisColumn::~BasisColumn()
    {
        delete ui;
    }

    void BasisColumn::updateValues()
    {
        ui->xSpinBox->setValue(_coord->x());
        ui->ySpinBox->setValue(_coord->y());
        ui->zSpinBox->setValue(_coord->z());
    }

    void BasisColumn::xChanged(double value)
    {
        if (_coord->x() != value) {
            _coord->x() = value;
            tripletChanged();
        }
    }

    void BasisColumn::yChanged(double value)
    {
        if (_coord->y() != value) {
            _coord->y() = value;
            tripletChanged();
        }
    }

    void BasisColumn::zChanged(double value)
    {
        if (_coord->z() != value) {
            _coord->z() = value;
            tripletChanged();
        }
    }
}
