#pragma once

#include <QWidget>
#include "EC/CharacteristicPolynomial.h"

namespace Ui {
    class ZeroItemWidget;
}

namespace cagd
{
    class ZeroItemWidget : public QWidget
    {
        Q_OBJECT

    public:
        explicit ZeroItemWidget(QWidget *parent = 0, CharacteristicPolynomial::Zero initialValue = {0,0,1});
        ~ZeroItemWidget();

        void setValidationVisibility(bool visible);
        void setPermanentZero();

        double getReal() { return _real; }
        double getImag() { return _imag; }
        int getMultiplicity() { return _multiplicity; }

    signals:
        void deletionRequested(QWidget *);
        void changesWereMade();

    private:
        double _real;
        double _imag;
        int _multiplicity;
        Ui::ZeroItemWidget *ui;

    private slots:
        void deletePressed();
        void realChanged(double value);
        void imagChanged(double value);
        void multiplicityChanged(int value);
    };
}
