#include "ZeroItemWidget.h"
#include "ui_ZeroItemWidget.h"

#include <QLabel>
#include <QDoubleSpinBox>
#include <QPushButton>

namespace cagd
{
    ZeroItemWidget::ZeroItemWidget(QWidget *parent, CharacteristicPolynomial::Zero initialValue):
        QWidget(parent),
        ui(new Ui::ZeroItemWidget)
    {
        ui->setupUi(this);

        connect(ui->deleteButton, SIGNAL(clicked()), this, SLOT(deletePressed()));
        connect(ui->realSpinBox, SIGNAL(valueChanged(double)), this, SLOT(realChanged(double)));
        connect(ui->imagSpinBox, SIGNAL(valueChanged(double)), this, SLOT(imagChanged(double)));
        connect(ui->multiplicitySpinBox, SIGNAL(valueChanged(int)), this, SLOT(multiplicityChanged(int)));

        auto validatorSizePolicy = ui->validationLabel->sizePolicy();
        validatorSizePolicy.setRetainSizeWhenHidden(true);
        ui->validationLabel->setSizePolicy(validatorSizePolicy);

        ui->validationLabel->setVisible(false);

        ui->realSpinBox->setValue(_real = initialValue.real);
        ui->imagSpinBox->setValue(_imag = initialValue.absImaginary);
        ui->multiplicitySpinBox->setValue(_multiplicity = initialValue.multiplicity);
    }

    ZeroItemWidget::~ZeroItemWidget()
    {
        delete ui;
    }

    void ZeroItemWidget::setValidationVisibility(bool visible)
    {
        ui->validationLabel->setVisible(visible);
    }

    void ZeroItemWidget::setPermanentZero()
    {
        ui->realSpinBox->setValue(0);
        ui->realSpinBox->setEnabled(false);
        ui->realSpinBox->setToolTip("Zero must be a root.");
        ui->imagSpinBox->setValue(0);
        ui->imagSpinBox->setEnabled(false);
        ui->imagSpinBox->setToolTip("Zero must be a root.");
        ui->deleteButton->setEnabled(false);
        ui->deleteButton->setToolTip("Zero must be a root.");
    }

    void ZeroItemWidget::deletePressed()
    {
        deletionRequested(this);
    }

    void ZeroItemWidget::realChanged(double value)
    {
        _real = value;
        changesWereMade();
    }

    void ZeroItemWidget::imagChanged(double value)
    {
        _imag = value;
        changesWereMade();
    }

    void ZeroItemWidget::multiplicityChanged(int value)
    {
        _multiplicity = value;
        changesWereMade();
    }
}
