#pragma once

#include <QDialog>
#include <QLayout>
#include <string>

#include "ZeroItemWidget.h"
#include "Utils/DoubleEquality.h"
#include "ECSpaceDatabase.h"

namespace Ui {
class SetupECSpacesDialog;
}

namespace cagd
{

    class SetupECSpacesDialog : public QDialog
    {
        Q_OBJECT

    private:
        Ui::SetupECSpacesDialog *ui;
        ECSpaceDatabase *_database;
        ECSpace *_originalSpace;

        ECSpace *_editedSpace;
        bool _wereAnyChangesMade;

        bool _allValidationOk;
        bool _domainValidationOk;
        bool _zerosValidationOk;

        QLayout *_zerosLayout = nullptr;
        QWidget *_previewWidget = nullptr;

    public:
        explicit SetupECSpacesDialog(QWidget *parent, ECSpaceDatabase *database, ECSpace *current);
        ~SetupECSpacesDialog();

    private slots:
        void tabChanged(int);
        void domainLeftChanged(double value);
        void domainRightChanged(double value);
        void addNewZeroItem();
        void deleteZeroItem(QWidget *);
        void updateAndValidateZeros();

        void undoChangesPressed();
        void saveForLaterUsePressed();
        void loadExistingSetupPressed();
        void savePressed();

    public slots:
        void reject() override;

    private:
        void changesWereMade();
        void propagateValidationResult();
        void validateDomain();
        void loadEditorData();
        void insertZero(CharacteristicPolynomial::Zero zero = {0,0,1}, bool setPermanentZero = false);
    };

}
