#pragma once

#include <QDialog>
#include <QString>
#include "ECSpaceDatabase.h"
#include "EC/ECSpace.h"

namespace Ui {
    class SaveForLaterUseDialog;
}

namespace cagd
{
    class SaveForLaterUseDialog : public QDialog
    {
        Q_OBJECT

    public:
        explicit SaveForLaterUseDialog(QWidget *parent, ECSpaceDatabase *database, ECSpace *ecSpaceToSave);
        ~SaveForLaterUseDialog();

    private:
        Ui::SaveForLaterUseDialog *ui;

        ECSpaceDatabase *_database;
        ECSpace *_ecSpaceToSave;

        QString _label;
        bool _labelValidationOk;

        void validateLabel();

    private slots:
        void labelChanged(QString);
        void saveToMemoryClicked();
        void saveToFileClicked();
    };
}
