#include "SaveForLaterUseDialog.h"
#include "ui_SaveForLaterUseDialog.h"

#include <QPushButton>
#include <QRadioButton>
#include <QLineEdit>
#include <QToolButton>
#include <QMessageBox>
#include <QLabel>
#include <QFileDialog>
#include <fstream>

namespace cagd
{
    SaveForLaterUseDialog::SaveForLaterUseDialog(QWidget *parent, ECSpaceDatabase *database, ECSpace *ecSpaceToSave):
        QDialog(parent),
        ui(new Ui::SaveForLaterUseDialog),
        _database(database),
        _ecSpaceToSave(ecSpaceToSave)
    {
        ui->setupUi(this);
        ui->invisibleButton->setDefault(true);
        ui->invisibleButton->setVisible(false);

        connect(ui->labelLineEdit, SIGNAL(textChanged(QString)), this, SLOT(labelChanged(QString)));
        connect(ui->saveToFileButton, SIGNAL(clicked()), this, SLOT(saveToFileClicked()));
        connect(ui->saveToMemoryButton, SIGNAL(clicked()), this, SLOT(saveToMemoryClicked()));

        _label = "";
        validateLabel();
    }

    SaveForLaterUseDialog::~SaveForLaterUseDialog()
    {
        delete ui;
    }

    void SaveForLaterUseDialog::validateLabel()
    {
        _labelValidationOk = true;

        if(_label.length() == 0)
        {
            _labelValidationOk = false;
            ui->labelValidation->setToolTip("Label should not be empty.");
        }
        else if (_label.length() > 100)
        {
            _labelValidationOk = false;
             ui->labelValidation->setToolTip("Label should be at most 100 characters long.");
        }

        ui->labelValidation->setVisible(!_labelValidationOk);
        ui->saveToMemoryButton->setEnabled(_labelValidationOk);
    }

    void SaveForLaterUseDialog::labelChanged(QString value)
    {
        _label = value;
        validateLabel();
    }

    void SaveForLaterUseDialog::saveToFileClicked()
    {
        auto fileName = QFileDialog::getSaveFileName(
            this,
            "Select File to Save",
            "MyECSpace.txt");

        if (fileName.length() > 0)
        {
            std::ofstream fout(fileName.toUtf8().constData());
            fout << *_ecSpaceToSave;
            fout.close();

            QMessageBox::information(this, "Save Done", "Saved to:\n" + fileName, QMessageBox::Ok);
            QDialog::accept();
        }
    }

    void SaveForLaterUseDialog::saveToMemoryClicked()
    {
        std::string labelString = _label.toUtf8().constData();

        if(_database->ecSpaces.find(labelString) != _database->ecSpaces.end())
        {
            auto result = QMessageBox::warning(
                this,
                "Overwrite",
                "This label already refers to an EC Space.\nOverwrite?",
                QMessageBox::Yes | QMessageBox::No);

            if(result != QMessageBox::Yes)
                return;
        }

        _database->ecSpaces[labelString] = new ECSpace(*_ecSpaceToSave);
        QMessageBox::information(this, "Saved", "Save Successful!\nLabel: " + _label, QMessageBox::Ok);

        QDialog::accept();
    }
}
