#pragma once

#include <QWidget>
#include <string>
#include "EC/ECSpace.h"

namespace Ui {
    class PreviewECWidget;
}

namespace cagd
{
    class PreviewECWidget : public QWidget
    {
        Q_OBJECT

    public:
        explicit PreviewECWidget(QWidget *parent, ECSpace *space);
        ~PreviewECWidget();

    private:
        Ui::PreviewECWidget *ui;
        ECSpace *_space;

        QColor _plotBackground;

        QWidget *desctiptionWidget();

        std::string domainRichText();
        std::string diffEquationRichText();
        std::string ordinaryBasesRichText();

        std::string format(double value);
        std::string formatTrimmed(double value);

    private slots:
        void colorButtonClicked();

    signals:
        void backgroundChanged(QColor value);
    };
}
