#pragma once

#include <vector>
#include <GL/glew.h>
#include <QGLWidget>
#include <QGLFormat>
#include <QColor>

#include "Core/GenericCurves3.h"
#include "EC/ECSpace.h"


namespace cagd
{
    class NNBBasesGLWidget: public QGLWidget
    {
        Q_OBJECT

    private:
        // variables defining the projection matrix
        float       _aspect;            // aspect ratio of the rendering window
        float       _fovy;              // field of view in direction y
        float       _z_near, _z_far;    // distance of near and far clipping planes

        // variables defining the model-view matrix
        float       _eye[3], _center[3], _up[3];

        ECSpace *_space;
        std::vector<GenericCurve3 *> _curves;
        float _backgroundColor[3];

    public:
        static const unsigned POINT_COUNT = 200;

        NNBBasesGLWidget(ECSpace *space, QWidget *parent,
                 const QGLFormat &format = QGL::Rgba | QGL::DepthBuffer | QGL::DoubleBuffer);

        void initializeGL();
        void paintGL();
        void resizeGL(int w, int h);

        virtual ~NNBBasesGLWidget();

    private:
        void setColor(unsigned colorIndex);

    public slots:
        void backgroundChanged(QColor);
    };

}
