#pragma once

#include <QDialog>
#include "ECSpaceDatabase.h"
#include "EC/ECSpace.h"

namespace Ui {
    class LoadExistingSpaceDialog;
}

namespace cagd
{
    class LoadExistingSpaceDialog : public QDialog
    {
        Q_OBJECT

    public:
        explicit LoadExistingSpaceDialog(QWidget *parent, ECSpaceDatabase *database, ECSpace *ecSpaceToModify);
        ~LoadExistingSpaceDialog();

    private:
        Ui::LoadExistingSpaceDialog *ui;

        ECSpaceDatabase *_database;
        ECSpace *_ecSpaceToModify;
        QString _comboSelection;

        bool confirmLoad();

    private slots:
        void loadClicked();
        void loadFromFileClicked();
        void comboSelectionChanged(QString);
    };
}
