#include "LoadExistingSpaceDialog.h"
#include "ui_LoadExistingSpaceDialog.h"

#include <QPushButton>
#include <QComboBox>
#include <QStringList>
#include <QMessageBox>
#include <QFileDialog>
#include <fstream>

namespace cagd
{
    LoadExistingSpaceDialog::LoadExistingSpaceDialog(
            QWidget *parent,
            ECSpaceDatabase *database,
            ECSpace *ecSpaceToModify) :
        QDialog(parent),
        ui(new Ui::LoadExistingSpaceDialog),
        _database(database),
        _ecSpaceToModify(ecSpaceToModify)
    {
        ui->setupUi(this);

        ui->invisibleButton->setDefault(true);
        ui->invisibleButton->setVisible(false);

        connect(ui->loadButton, SIGNAL(clicked()), this, SLOT(loadClicked()));
        connect(ui->loadFromFileButton, SIGNAL(clicked()), this, SLOT(loadFromFileClicked()));
        connect(ui->ecSpacesComboBox, SIGNAL(currentTextChanged(QString)), this, SLOT(comboSelectionChanged(QString)));

        ui->loadButton->setEnabled(false);

        int index = 0;
        ui->ecSpacesComboBox->insertItem(index++, "Select...");

        for (auto p : _database->ecSpaces)
            ui->ecSpacesComboBox->insertItem(index++, p.first.c_str());
    }

    LoadExistingSpaceDialog::~LoadExistingSpaceDialog()
    {
        delete ui;
    }

    void LoadExistingSpaceDialog::loadClicked()
    {
        std::string label = _comboSelection.toUtf8().constData();
        ECSpace *source = _database->ecSpaces[label];

        if (!confirmLoad())
            return;

        _ecSpaceToModify->definitionDomain = source->definitionDomain;
        _ecSpaceToModify->characteristicPolynomial = source->characteristicPolynomial;
        QDialog::accept();
    }

    void LoadExistingSpaceDialog::loadFromFileClicked()
    {
        auto fileName = QFileDialog::getOpenFileName(
            this,
            "Select File to Open",
            "MyECSpace.txt");

        if (fileName.length() > 0)
        {
            if (!confirmLoad())
                return;

            std::ifstream fin(fileName.toUtf8().constData());
            fin >> *_ecSpaceToModify;
            QDialog::accept();
        }
    }

    void LoadExistingSpaceDialog::comboSelectionChanged(QString value)
    {
        _comboSelection = value;
        ui->loadButton->setEnabled(value.length() > 0 && value != "Select...");
    }

    bool LoadExistingSpaceDialog::confirmLoad()
    {
        auto result = QMessageBox::warning(
            this,
            "Confirm Load",
            "Changes in the editor will be overwritten.\nContinue?",
            QMessageBox::Yes | QMessageBox::No);
        return result == QMessageBox::Yes;
    }
}
