#pragma once

#include <QWidget>
#include "Model/Scene.h"

namespace Ui {
class PointSetupTab;
}

namespace cagd
{
    class PointSetupTab : public QWidget
    {
        Q_OBJECT

    public:
        explicit PointSetupTab(QWidget *parent, Scene *scene);
        ~PointSetupTab();

    private:
        const double SPIN_EPS = 10e-8;

        Ui::PointSetupTab *ui;
        Scene *_scene;

    signals:
        void configChanged();

    public slots:
        void updateFromScene();

    private slots:
        void xValueChanged(double);
        void yValueChanged(double);
        void zValueChanged(double);
    };
}
