#include "PointSetupTab.h"
#include "ui_PointSetupTab.h"

#include <QDoubleSpinBox>

namespace cagd
{
    PointSetupTab::PointSetupTab(QWidget *parent, Scene *scene) :
        QWidget(parent),
        ui(new Ui::PointSetupTab),
        _scene(scene)
    {
        ui->setupUi(this);

        connect(ui->xSpinBox, SIGNAL(valueChanged(double)), this, SLOT(xValueChanged(double)));
        connect(ui->ySpinBox, SIGNAL(valueChanged(double)), this, SLOT(yValueChanged(double)));
        connect(ui->zSpinBox, SIGNAL(valueChanged(double)), this, SLOT(zValueChanged(double)));
    }

    PointSetupTab::~PointSetupTab()
    {
        delete ui;
    }

    void PointSetupTab::updateFromScene()
    {
        DCoordinate3 *point = _scene->selection.selectedPoint;
        if (!point) return;

        ui->xSpinBox->setValue(point->x());
        ui->ySpinBox->setValue(point->y());
        ui->zSpinBox->setValue(point->z());
    }

    void PointSetupTab::xValueChanged(double value)
    {
        DCoordinate3 *point = _scene->selection.selectedPoint;
        if (!point) return;

        if (std::abs(point->x() - value) > SPIN_EPS) {
            point->x() = value;
            _scene->selection.selectedItem->update();
            configChanged();
        }
    }

    void PointSetupTab::yValueChanged(double value)
    {
        DCoordinate3 *point = _scene->selection.selectedPoint;
        if (!point) return;

        if (std::abs(point->y() - value) > SPIN_EPS) {
            point->y() = value;
            _scene->selection.selectedItem->update();
            configChanged();
        }
    }

    void PointSetupTab::zValueChanged(double value)
    {
        DCoordinate3 *point = _scene->selection.selectedPoint;
        if (!point) return;

        if (std::abs(point->z() - value) > SPIN_EPS) {
            point->z() = value;
            _scene->selection.selectedItem->update();
            configChanged();
        }
    }
}
