#pragma once

#include "../../EC/BSurface3.h"
#include "../../Core/Materials.h"
#include "SceneItem.h"

namespace cagd
{
    class SurfaceItem: public SceneItem
    {
    public:
        ECSpace *ecSpaceU;
        ECSpace *ecSpaceV;
        BSurface3 *bsurface;
        TriangulatedMesh3 *image;
        RowMatrix<GenericCurve3 *> *uIsoLines;
        RowMatrix<GenericCurve3 *> *vIsoLines;

        Material *material;
        Color4 normalsColor;
        Color4 isoLinesColor;
        bool alwaysShowControlNet;
        bool showIsoparametricLines;
        bool showNormals;

        SurfaceItem(Scene *scene);
        virtual ~SurfaceItem();

        virtual void render(bool isSelected = false);
        virtual void update();
        virtual void regenerate();

        virtual PickResult pickControlPointClosestToRay(HCoordinate3 rayPoint1, HCoordinate3 rayPoint2);
        virtual double itemDistanceFromPointIfCloseToRay(
            HCoordinate3 point,
            HCoordinate3 otherRayPoint,
            double rayDistanceThreshold);
        virtual void transform(const RealMatrix &transformation);
        virtual DCoordinate3 centerOfGravity();

        void performOrderElevationU(double reZero, double imZero, int multiplicity);
        void performOrderElevationV(double reZero, double imZero, int multiplicity);
        void performSubdivisionU(double point);
        void performSubdivisionV(double point);
        void updateControlPointsForExactDescription(const std::vector<DCoordinate3> &coefficients);

        friend std::ostream &operator<<(std::ostream &out, const SurfaceItem &surfaceItem);
        friend std::istream &operator>>(std::istream &in, SurfaceItem &surfaceItem);

    private:
        void deleteIsoLines();
    };

    std::ostream &operator<<(std::ostream &out, const SurfaceItem &surfaceItem);
    std::istream &operator>>(std::istream &in, SurfaceItem &surfaceItem);


}
