#pragma once

#include "../../Core/HCoordinates3.h"
#include "Scene.h"

namespace cagd
{
    class Scene;

    class SceneItem
    {
    public:
        Scene *scene;

        SceneItem(Scene *scene): scene(scene) {}
        virtual ~SceneItem() {}

        virtual void render(bool isSelected = false) = 0;
        virtual void update() = 0;
        virtual void regenerate() = 0;

        struct PickResult {
            double distance;
            DCoordinate3 *point;
        };

        virtual PickResult pickControlPointClosestToRay(HCoordinate3 rayPoint1, HCoordinate3 rayPoint2) = 0;
        virtual double itemDistanceFromPointIfCloseToRay(
            HCoordinate3 point,
            HCoordinate3 otherRayPoint,
            double rayDistanceThreshold) = 0;
        virtual void transform(const RealMatrix &transformation) = 0;
        virtual DCoordinate3 centerOfGravity() = 0;
    };
}
