#pragma once

#include <list>
#include "../../Core/Colors4.h"
#include "../../Core/ShaderPrograms.h"
#include "../SetupECSpaces/ECSpaceDatabase.h"
#include "SceneItem.h"

namespace cagd
{
    class SceneItem;

    class Scene
    {
    public:
        ECSpaceDatabase *ecSpaceDatabase;
        ShaderProgram *shaderProgram;

        std::list<SceneItem *> items;

        struct Selection {
              SceneItem *selectedItem;
              DCoordinate3 *selectedPoint;

              Selection();
              bool isWholeItem();
              bool isPoint();
              bool operator ==(const Selection &rhs);
              bool operator !=(const Selection &rhs);
              void setNull();
        } selection;
        bool shouldTriggerTabChange;

        Color4 backgroundColor;
        Color4 controlLinesColor;
        float lineWidth;
        float lineWidthForSelection;
        int curveMaxDerivOrder;
        int curveDivPointCount;

        int surfaceDivPointCount;
        int isoparametricLineCount;

        Scene();
        ~Scene();

        void render();
        void deleteItem(SceneItem *item);
    };
}
