#include "Scene.h"
#include "../../EC/BCurve3.h"
#include "CurveItem.h"
#include "SurfaceItem.h"
#include <cmath>

namespace cagd
{
    Scene::Scene():
        ecSpaceDatabase(new ECSpaceDatabase()),
        shouldTriggerTabChange(false),
        backgroundColor(0, 0, 0),
        controlLinesColor(1, 1, 1),
        lineWidth(1),
        lineWidthForSelection(2.5),
        curveMaxDerivOrder(2),
        curveDivPointCount(100),
        surfaceDivPointCount(30),
        isoparametricLineCount(8)
    {
    }

    Scene::~Scene() {
        delete ecSpaceDatabase;
        for (auto ptr : items)
            delete ptr;
    }

    void Scene::render()
    {
        for (auto item : items)
            item->render(selection.selectedItem == item);
    }

    void Scene::deleteItem(SceneItem *item)
    {
        delete item;
        items.remove(item);

        if (selection.selectedItem == item) {
            selection.selectedItem = nullptr;
            selection.selectedPoint = nullptr;
        }
    }

    Scene::Selection::Selection()
    {
        setNull();
    }

    bool Scene::Selection::isWholeItem()
    {
        return selectedItem != nullptr && selectedPoint == nullptr;
    }

    bool Scene::Selection::isPoint()
    {
        return selectedPoint != nullptr;
    }

    bool Scene::Selection::operator ==(const Scene::Selection &rhs)
    {
        return selectedItem == rhs.selectedItem && selectedPoint == rhs.selectedPoint;
    }

    bool Scene::Selection::operator !=(const Scene::Selection &rhs)
    {
        return selectedItem != rhs.selectedItem || selectedPoint != rhs.selectedPoint;
    }

    void Scene::Selection::setNull()
    {
        selectedItem = nullptr;
        selectedPoint = nullptr;
    }

}
