#pragma once

#include "../../Core/Colors4.h"
#include "../../EC/BCurve3.h"
#include "SceneItem.h"
#include <iostream>

namespace cagd
{
    class CurveItem : public SceneItem
    {
    public:
        ECSpace *ecSpace;
        BCurve3 *bcurve;
        GenericCurve3 *image;
        Color4 color;
        Color4 derivColor;
        Color4 secondDerivColor;

        bool alwaysShowControlPolygon;
        bool showFirstDerivatives;
        bool showSecondDerivatives;

        CurveItem(Scene *scene);
        virtual ~CurveItem();

        virtual void render(bool isSelected = false);
        virtual void update();
        virtual void regenerate();

        virtual PickResult pickControlPointClosestToRay(HCoordinate3 rayPoint1, HCoordinate3 rayPoint2);
        virtual double itemDistanceFromPointIfCloseToRay(
            HCoordinate3 point,
            HCoordinate3 otherRayPoint,
            double rayDistanceThreshold);
        virtual void transform(const RealMatrix &transformation);
        virtual DCoordinate3 centerOfGravity();

        void performOrderElevation(double real, double absImag, unsigned multiplicity);
        void performSubdivision(double gamma);
        void updateControlPointsForExactDescription(const std::vector<DCoordinate3> &coefficients);

        friend std::ostream &operator<<(std::ostream &out, const CurveItem &curveItem);
        friend std::istream &operator>>(std::istream &in, CurveItem &curveItem);
    };

    std::ostream &operator<<(std::ostream &out, const CurveItem &curveItem);
    std::istream &operator>>(std::istream &in, CurveItem &curveItem);
}
