#pragma once

#include <QMainWindow>
#include <QScrollArea>
#include "ui_MainWindow.h"
#include "GLWidget.h"
#include "SideWidget.h"
#include "SetupECSpaces/ECSpaceDatabase.h"
#include "Model/Scene.h"

namespace cagd
{
    class MainWindow: public QMainWindow, public Ui::MainWindow
    {
        Q_OBJECT

    private:
        SideWidget *_side_widget;
        GLWidget *_gl_widget;
        QScrollArea *_scroll_area;

        Scene *_scene;

    public:
        MainWindow(QWidget *parent = nullptr);
        ~MainWindow();

    private slots:
        void on_actionQuit_triggered();

        void openGlInitialized();
    };

}
