#include "MainWindow.h"
#include "SetupECSpaces/SetupECSpacesDialog.h"
#include "../Core/Exceptions.h"

#include <QHBoxLayout>

namespace cagd
{
    MainWindow::MainWindow(QWidget *parent):
        QMainWindow(parent)
    {
        setupUi(this);

        _scene = new Scene();

        _side_widget = new SideWidget(this, _scene);
        _gl_widget = new GLWidget(this, _scene);
        _gl_widget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
        _gl_widget->setMinimumWidth(850);

        auto layout = new QHBoxLayout();
        auto content = new QWidget(this);
        content->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding);
        layout->setMargin(0);
        layout->setSpacing(4);
        content->setLayout(layout);
        layout->addWidget(_gl_widget);
        layout->addWidget(_side_widget);

        _scroll_area = new QScrollArea(this);
        _scroll_area->setWidget(content);
        _scroll_area->setWidgetResizable(true);
        _scroll_area->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
        _scroll_area->setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);

        setCentralWidget(_scroll_area);

        connect(_side_widget, SIGNAL(modifiedTheScene()), _gl_widget, SLOT(updateGL()));
        connect(_gl_widget, SIGNAL(initialized()), this, SLOT(openGlInitialized()));
        connect(_gl_widget, SIGNAL(modifiedTheSelection()), _side_widget, SLOT(sceneChanged()));

        connect(_side_widget, SIGNAL(setDefaultView()), _gl_widget, SLOT(clearViewTransformations()));
        connect(_side_widget, SIGNAL(moveSelectionToCenter()), _gl_widget, SLOT(moveSelectionToCenter()));
        connect(_side_widget, SIGNAL(activateMainGLWidget()), _gl_widget, SLOT(setAsCurrent()));
    }

    MainWindow::~MainWindow()
    {
        delete _scene;
    }

    void MainWindow::on_actionQuit_triggered()
    {
        qApp->exit(0);
    }

    void MainWindow::openGlInitialized()
    {
        _side_widget->sceneChanged();
    }
}
