#pragma once

#include <string>
#include <QWidget>
#include "Model/Scene.h"

namespace Ui {
    class CurveSetupTab;
}

namespace cagd
{
    class CurveSetupTab : public QWidget
    {
        Q_OBJECT

    public:
        explicit CurveSetupTab(QWidget *parent, Scene *scene);
        ~CurveSetupTab();

    signals:
        void configChanged();
        void activateMainGLWidget();

    public slots:
        void updateFromScene();

    private:
        Ui::CurveSetupTab *ui;
        Scene *_scene;

        std::string formatDouble(double d) const;

    private slots:
        void setupECSpaceClicked();
        void exactDescriptionClicked();
        void alwaysShowPolygonChanged(bool);
        void showFirstDerivChanged(bool);
        void showSecondDerivChanged(bool);
        void setZerothDerColor();
        void setFirstDerColor();
        void setSecondDerColor();
        void performOrderElevation();
        void performSubdivision();
        void deleteCurve();
        void saveCurveToFile();
    };
}
