#include "CommonUITools.h"

#include <QColorDialog>
#include <cstdlib>


namespace cagd
{
    std::vector<Material*> CommonUITools::listOfMaterials(
        {&MatFBBrass, &MatFBEmerald, &MatFBGold, &MatFBPearl, &MatFBRuby, &MatFBSilver, &MatFBTurquoise});

    Material *CommonUITools::getRandomMaterial()
    {
        return listOfMaterials[std::rand() % listOfMaterials.size()];
    }

    Color4 CommonUITools::getRandomLightColor()
    {
        return Color4(
            0.2f + (float) std::rand() * 0.8f / (float) RAND_MAX,
            0.2f + (float) std::rand() * 0.8f / (float) RAND_MAX,
                    0.2f + (float) std::rand() * 0.8f / (float) RAND_MAX);
    }

    void CommonUITools::setRenderingColor(Color4 arg)
    {
        glColor4f(arg.r(), arg.g(), arg.b(), arg.a());
    }

    bool CommonUITools::changeColorViaPopup(Color4 &color)
    {
        QColor old;
        old.setRedF(color.r());
        old.setGreenF(color.g());
        old.setBlueF(color.b());

        auto result = QColorDialog::getColor(old);
        if (result.isValid()) {
            qreal r,g,b;
            result.getRgbF(&r, &g, &b);
            color.r() = (float) r;
            color.g() = (float) g;
            color.b() = (float) b;
            return true;
        }

        return false;
    }
}

