#pragma once

#include <string>

namespace cagd
{
    class OrdinaryBasisFunction
    {
    public:
        unsigned xPow;
        double expCoef;
        double trigCoef;
        bool isSine;

        OrdinaryBasisFunction();
        OrdinaryBasisFunction(unsigned xPow, double expCoef, double trigCoef = 0, bool isSine = false);
        double getDerivative(unsigned order, double input) const;

        std::string getHTMLRepresentation(std::string variable = "x") const;

    private:
        const char *BEGIN_ALIGN_SUPER = "<span style=\"vertical-align:super;\">";
        const char *END_ALIGN_SUPER = "</span>";

        typedef double (OrdinaryBasisFunction::*FunctionTerm)(unsigned, double) const;

        double polyDerivative(unsigned order, double input) const;
        double expDerivative(unsigned order,  double input) const;
        double trigDerivative(unsigned order, double input) const;
        double generalLeibniz(unsigned order, double input, FunctionTerm f1, FunctionTerm f2) const;
        double generalLeibniz(unsigned order, double input, FunctionTerm f1, FunctionTerm f2, FunctionTerm f3) const;

        std::string formatTrimmed(double value) const;
    };
}
