#pragma once

#include "CharacteristicPolynomial.h"
#include "OrdinaryBasisFunction.h"
#include "../Core/RealMatrices.h"
#include <utility>
#include <complex>
#include <vector>
#include <string>
#include <iostream>

namespace cagd
{
    class ECSpace
    {
    public:
        std::pair<double, double> definitionDomain;
        CharacteristicPolynomial characteristicPolynomial;

        ECSpace();
        ECSpace(const ECSpace &ecSpace);
        const ECSpace &operator =(const ECSpace &rightSide);

        // Preprocessing is needed when the definitionDomain or the characteristicPolynomial changes:
        void preprocessing();

        std::vector<OrdinaryBasisFunction> ordBases;
        unsigned getDimension() const;
        double NNBBaseDerivative(unsigned index, unsigned deriv_order, double input) const;
        ECSpace *getAugmentedECSpace(CharacteristicPolynomial::Zero zeroToAdd) const;
        RealMatrix getBasisTransformationMatrix() const;

    private:
        unsigned _dimension;
        bool _isReflectionInvariant;
        RealMatrix _rho;
        RealMatrix _mu;
        std::vector<double> _lambda;

        void setupOrdBases();
        void calculateRho();
        void calculateMuAndLambda();
    };

    std::ostream &operator<<(std::ostream &stream, const ECSpace &space);
    std::istream &operator>>(std::istream &stream, ECSpace &space);
}
