#pragma once
#include <vector>
#include <iostream>

namespace cagd
{
    class CharacteristicPolynomial
    {
    public:
        struct Zero {
            double real;
            double absImaginary;
            int multiplicity;

            bool operator ==(const Zero &rightSide) const;
            bool operator !=(const Zero &rightSide) const;
        };

        std::vector<Zero> zeros;

        CharacteristicPolynomial();
        CharacteristicPolynomial(const CharacteristicPolynomial &polynomial);
        const CharacteristicPolynomial &operator= (const CharacteristicPolynomial &rightSide);

        CharacteristicPolynomial(const std::vector<Zero> zeros): zeros(zeros) {}
        int getGrade();
        std::vector<double> getCoefficients();
        bool isOddOrEvenFuncion();

        friend std::ostream &operator<<(std::ostream &stream, const CharacteristicPolynomial &polynomial);
        friend std::istream &operator>>(std::istream &stream, CharacteristicPolynomial &polynomial);

    private:
        void multiply(std::vector<double> &destination, std::initializer_list<double> multiplier);
    };

    std::ostream &operator<<(std::ostream &stream, const CharacteristicPolynomial &polynomial);
    std::istream &operator>>(std::istream &stream, CharacteristicPolynomial &polynomial);
}
