#pragma once
#include "ECSpace.h"
#include "../Core/TensorProductSurfaces3.h"
#include <unordered_map>

namespace cagd
{
    class BSurface3: public TensorProductSurface3
    {
    private:
        const ECSpace *_ecSpaceU;
        const ECSpace *_ecSpaceV;

        unsigned _cache_u_count;
        unsigned _cache_v_count;
        std::unordered_map<unsigned, double> _u_derivative_cache;
        std::unordered_map<unsigned, double> _v_derivative_cache;

        unsigned getKey(unsigned index, unsigned order, unsigned knot);
        double getNNBDerivativeU(unsigned index, unsigned order, double u);
        double getNNBDerivativeV(unsigned index, unsigned order, double v);

    public:
        BSurface3(const ECSpace *ecSpaceU, const ECSpace *ecSpaceV);

        GLboolean UBlendingFunctionValues(GLdouble u_knot, RowMatrix<GLdouble> &blending_values);
        GLboolean VBlendingFunctionValues(GLdouble v_knot, RowMatrix<GLdouble> &blending_values);

        GLboolean CalculatePartialDerivatives(GLuint maximum_order_of_partial_derivatives, GLdouble u, GLdouble v, PartialDerivatives &pd);

        std::pair<ECSpace *, BSurface3 *> performUOrderElevation(double reZero, double imZero, int multiplicity) const;
        std::pair<ECSpace *, BSurface3 *> performVOrderElevation(double reZero, double imZero, int multiplicity) const;

        struct SubdivisionResult {
            ECSpace *ecSpaceLeft;
            BSurface3 *bSurfaceLeft;
            ECSpace *ecSpaceRight;
            BSurface3 *bSurfaceRight;
        };
        SubdivisionResult performUSubdivision(double gamma) const;
        SubdivisionResult performVSubdivision(double gamma) const;

        const ECSpace *getECSpaceU() const {return _ecSpaceU;}
        const ECSpace *getECSpaceV() const {return _ecSpaceV;}

        void updateControlPointsForExactDescription(const std::vector<DCoordinate3> &coefficients);

        virtual TriangulatedMesh3* GenerateImage(
            GLuint u_div_point_count, GLuint v_div_point_count,
            GLenum usage_flag = GL_STATIC_DRAW);
    };
}
