#pragma once

#include "../Core/LinearCombination3.h"
#include "ECSpace.h"

namespace cagd
{
    class BCurve3: public LinearCombination3
    {
    private:
        const ECSpace* _ecSpace;

    public:
        BCurve3(const ECSpace* ecSpace);

        virtual GLboolean BlendingFunctionValues(GLdouble u, RowMatrix<GLdouble>& values) const;
        virtual GLboolean CalculateDerivatives(GLuint max_order_of_derivatives, GLdouble u, Derivatives& d) const;

        std::pair<ECSpace*, BCurve3*> performOrderElevation(double reZero, double imZero, int multiplicity) const;
        bool calculateDataForOrderElevatedCurve(ECSpace *newECSpace, BCurve3 *newCurve) const;

        struct SubdivisionResult {
            ECSpace *ecSpaceLeft;
            BCurve3 *bCurveLeft;
            ECSpace *ecSpaceRight;
            BCurve3 *bCurveRight;
        };
        SubdivisionResult performSubdivision(double gamma) const;
        void fillSubdivisionValues(SubdivisionResult &result, double alpha, double gamma, double beta) const;
        void updateControlPointsForExactDescription(const std::vector<DCoordinate3> &coefficients);
    };
}
