#pragma once

#include "Matrices.h"

namespace cagd
{
    class RealMatrix: public Matrix<double> {
    public:
        RealMatrix(int row_count, int column_count);

        const RealMatrix operator +(const RealMatrix &rhs) const;
        const RealMatrix operator -(const RealMatrix &rhs) const;
        const RealMatrix operator *(const RealMatrix &rhs) const;
        const RealMatrix operator *(const double &rhs) const;
        friend const RealMatrix operator *(const double &lhs, const RealMatrix &rhs);
        const RealMatrix operator *(const ColumnMatrix<double> &rhs) const;
        friend const RealMatrix operator *(const RowMatrix<double> &lhs, const RealMatrix &rhs);
        friend const RealMatrix operator *(const ColumnMatrix<double> &lhs, const RowMatrix<double> &rhs);
        friend RowMatrix<double>& operator *=(RowMatrix<double> &lhs, const RealMatrix &rhs);
        const RealMatrix operator /(const double &rhs) const;
        RealMatrix& operator +=(const RealMatrix &rhs);
        RealMatrix& operator -=(const RealMatrix &rhs);
        RealMatrix& operator *=(const RealMatrix &rhs);
        RealMatrix& operator *=(const double &rhs);
        RealMatrix& operator *=(const ColumnMatrix<double>& rhs);
        RealMatrix& operator /=(const double &rhs);
        void loadNullMatrix();
        void loadIdentityMatrix();
        RealMatrix transpose() const;
        bool isSquare() const;
        bool isRowMatrix() const;
        bool isColumnMatrix() const;
        RealMatrix* clone() const;
    };


    const RealMatrix operator *(const double &lhs, const RealMatrix &rhs);
    const RealMatrix operator *(const RowMatrix<double> &lhs, const RealMatrix &rhs);
    const RealMatrix operator *(const ColumnMatrix<double> &lhs, const RowMatrix<double> &rhs);
    RowMatrix<double>& operator *=(RowMatrix<double> &lhs, const RealMatrix &rhs);
    double operator *(const RowMatrix<double> &lhs, const ColumnMatrix<double> &rhs);

    const RowMatrix<double> operator +(const RowMatrix<double> &lhs, const RowMatrix<double> &rhs);
    const RowMatrix<double> operator -(const RowMatrix<double> &lhs, const RowMatrix<double> &rhs);
    const RowMatrix<double> operator *(const RowMatrix<double> &lhs, const double &rhs);
    const RowMatrix<double> operator *(const double &lhs, const RowMatrix<double> &rhs);
    RowMatrix<double>& operator +=(RowMatrix<double> &lhs, const RowMatrix<double> &rhs);
    RowMatrix<double>& operator -=(RowMatrix<double> &lhs, const RowMatrix<double> &rhs);
    RowMatrix<double>& operator *=(RowMatrix<double> &lhs, const double &rhs);
    RowMatrix<double>& operator /=(RowMatrix<double> &lhs, const double &rhs);
    const ColumnMatrix<double> operator +(const ColumnMatrix<double> &lhs, const ColumnMatrix<double> &rhs);
    const ColumnMatrix<double> operator -(const ColumnMatrix<double> &lhs, const ColumnMatrix<double> &rhs);
    const ColumnMatrix<double> operator *(const ColumnMatrix<double> &lhs, const double &rhs);
    const ColumnMatrix<double> operator *(const double &lhs, const ColumnMatrix<double> &rhs);
    ColumnMatrix<double>& operator +=(ColumnMatrix<double> &lhs, const ColumnMatrix<double> &rhs);
    ColumnMatrix<double>& operator -=(ColumnMatrix<double> &lhs, const ColumnMatrix<double> &rhs);
    ColumnMatrix<double>& operator *=(ColumnMatrix<double> &lhs, const double &rhs);
    ColumnMatrix<double>& operator /=(ColumnMatrix<double> &lhs, const double &rhs);
}
